<?php
/*--------------------------------------------------------------
   Text.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Text\Value;

class Text implements Data
{
    /**
     * @var Value
     */
    private $text;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(Value $text)
    {
        $this->text = $text;
        $this->type = 'text';
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Value $text): self
    {
        return new self($text);
    }
    
    
    /**
     * Return text.
     */
    public function text(): Value
    {
        return $this->text;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
}